<?php
$bridge_qode_options = bridge_qode_return_global_options();
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<?php
    $bridge_qode_is_IE = bridge_qode_return_is_ie_variable();

	if ( ! empty( $bridge_qode_is_IE ) && $bridge_qode_is_IE ) { ?>
		<meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
	<?php } ?>

	<?php
	/**
	 * bridge_qode_header_meta hook
	 *
	 * @see bridge_core_header_meta() - hooked with 10
	 * @see bridge_qode_user_scalable_meta() - hooked with 10
	 */
	do_action('bridge_qode_action_header_meta');
	?>

	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

	<?php wp_head(); ?>
	
	
	<!-- WhatsHelp.io widget -->
<script type="text/javascript">
    (function () {
        var options = {
            whatsapp: " +6591849795", // WhatsApp number
            company_logo_url: "https://tuteelearning.sg/wp-content/uploads/2020/02/favicon.png", // URL of company logo (png, jpg, gif)
            greeting_message: "Hello, can we help You?", // Text of greeting message
            call_to_action: "Contact Us", // Call to action
            position: "left", // Position may be 'right' or 'left'
        };
        var proto = document.location.protocol, host = "whatshelp.io", url = proto + "//static." + host;
        var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
        s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
        var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
    })();
</script>
<!-- /WhatsHelp.io widget -->
	
	
</head>

<body <?php body_class(); ?> itemscope itemtype="http://schema.org/WebPage">


<?php
//Wordpress 5.2 default action
do_action( 'wp_body_open' );

?>

<?php
$params = bridge_qode_header_parameters();
extract($params);

echo bridge_qode_get_module_template_part('templates/parts/ajax-loader', 'header');

echo bridge_qode_get_module_template_part('templates/side-area/side-area', 'header', '', $params);
?>

<div class="wrapper">
	<div class="wrapper_inner">

    <?php do_action('bridge_qode_action_after_wrapper_inner'); ?>

	<?php
    if($enable_vertical_menu) {
		echo bridge_qode_get_module_template_part('templates/vertical-header', 'header', '', $params);
	}else{
        switch($header_bottom_appearance){
            case 'stick menu_bottom':
				$header_appearance_slug = 'stick_menu_bottom';
                break;
            case 'fixed fixed_minimal':
                $header_appearance_slug = 'fixed_minimal';
                break;
            default:
                $header_appearance_slug = $header_bottom_appearance;
            break;
        }
        echo bridge_qode_get_module_template_part('templates/header-appearance/header', 'header', $header_appearance_slug, $params);
    }

	echo bridge_qode_get_module_template_part('templates/parts/back-to-top', 'header', '', $params);
	echo bridge_qode_get_module_template_part('templates/popup-menu/popup-menu', 'header', '', $params);
	echo bridge_qode_get_module_template_part('templates/parts/fullscreen-search', 'header', '', $params);
    ?>
	
	
    <?php if(bridge_qode_options()->getOptionValue('paspartu') == 'yes'){ ?>
    <div class="paspartu_outer <?php echo bridge_qode_get_paspartu_class(); ?>">
        <?php if(bridge_qode_options()->getOptionValue('vertical_area') == "yes" && bridge_qode_options()->getOptionValue('vertical_menu_inside_paspartu') == 'no') { ?>
            <div class="paspartu_middle_inner">
        <?php }?>

        <?php if((bridge_qode_options()->getOptionValue('paspartu_on_top') == 'yes' && bridge_qode_options()->getOptionValue('paspartu_on_top_fixed') == 'yes') ||
            (bridge_qode_options()->getOptionValue('vertical_area') == "yes" && bridge_qode_options()->getOptionValue('vertical_menu_inside_paspartu') == 'yes')){ ?>
            <div class="paspartu_top"></div>
        <?php }?>

        <div class="paspartu_left"></div>
        <div class="paspartu_right"></div>
        <div class="paspartu_inner">
    <?php } ?>

    <?php if(is_active_sidebar('left_side_fixed')){ ?>
        <div class="qode_left_side_fixed">
            <?php 
                dynamic_sidebar('left_side_fixed');
            ?>
        </div>
    <?php } ?>

    <div class="content <?php echo bridge_qode_get_content_class(); ?>">
    <?php
    $animation = get_post_meta($id, "qode_show-animation", true);
    if (!empty($_SESSION['qode_animation']) && $animation == ""){ $animation = $_SESSION['qode_animation']; }
    if(in_array(bridge_qode_options()->getOptionValue('page_transitions'), array('1', '2', '3', '4')) || in_array($animation, array("updown","fade","updown_fade","leftright"))){ ?>
        <div class="meta">

            <?php
            /**
             * bridge_qode_action_ajax_meta hook
             *
             * @hooked bridge_qode_action_ajax_meta - 10
             */
            do_action('bridge_qode_action_ajax_meta'); ?>

            <span id="qode_page_id"><?php echo esc_attr( bridge_qode_get_page_id() ); ?></span>
            <div class="body_classes"><?php echo implode( ',', get_body_class()); ?></div>
        </div>
    <?php } ?>
    <div class="content_inner <?php echo esc_attr( $animation );?> ">
    <?php if(in_array(bridge_qode_options()->getOptionValue('page_transitions'), array('1', '2', '3', '4')) || in_array($animation, array("updown","fade","updown_fade","leftright"))){
         do_action('bridge_qode_action_visual_composer_custom_shortcodce_css');
    } ?>
