jQuery(document).ready(function($) {

	let wizard = $( '#epkb-config-wizard-content' );
	let need_to_apply_theme = true;
	
	// If the Wizard is not detected don't run scripts.
	if ( wizard.length <= 0 ) {
		return;
	}

	/**
	 * Highlight all completed steps in status bar.
	 */
	function wizard_status_bar_highlight_completed_steps( nextStep ){

		// Clear Completed Classes
		wizard.find( '.epkb-wizard-status-bar .epkb-wsb-step' ).removeClass( 'epkb-wsb-step--completed' );

		wizard.find( '.epkb-wizard-status-bar .epkb-wsb-step' ).each( function(){

			// Get each Step ID
			id = $( this ).attr( 'id' );

			// Get last character the number of each ID
			let lastChar = id[id.length -1];

			// If the ID is less than the current step then add completed class.
			if( lastChar < nextStep ){
				$( this ).addClass( 'epkb-wsb-step--completed' );
			}
		});
	}

	/**
	 * Change Next button to apply button on last step.
	 * Remove Class for all steps other than the first: epkb-wizard-button-container--first-step
	 */
	function wizard_change_buttons(){
		wizard.find( '.epkb-wizard-button-container' ).removeClass( 'epkb-wizard-button-container--final-step' );
		wizard.find( '.epkb-wizard-button-container' ).removeClass( 'epkb-wizard-button-container--first-step' );

		let id = wizard.find( '.epkb-wsb-step--active' ).attr( 'id' );

		// Get last character the number of each ID
		let lastChar = Number(id[id.length - 1]);
		let stepLength = $('.epkb-wizard-status-bar li.epkb-wsb-step').length;
		if( lastChar === 1 ){
			wizard.find( '.epkb-wizard-button-container' ).addClass( 'epkb-wizard-button-container--first-step' );
		}
		
		if( lastChar === stepLength ){
			wizard.find( '.epkb-wizard-button-container' ).addClass( 'epkb-wizard-button-container--final-step' );
		}
	}

	/**
	 * Change the Top Description based on step.
	 */
	function wizard_show_step_description(){

		// Get the current active step ID
		let id = $( '.epkb-wsb-step--active' ).attr( 'id' );

		// Get last character the number of each ID
		let lastChar = Number(id[id.length -1]);

		// Clear all active classes
		$( '.epkb-wizard-header__desc__step' ).removeClass( 'epkb-wizard-desc-active' );

		// Set the Active class based on ID
		$( '#epkb-wizard-desc-step-'+lastChar ).addClass( 'epkb-wizard-desc-active' );

	}
	
	/**
	 * Special functions for the turning steps to move data between steps 
	 */
	
	
	function wizard_changed_step(from, to) {

		// update KB name at the top
		if ( from == 1 && to == 2 ) {
			
			// Color wizard
			if ( $('.epkb-wizard-name input').length ) {
				$('#epkb_current_kb_name').text($('.epkb-wizard-name input').val());
			}
		}

		// update preview from theme selection on Main Page colors
		if ( from == 2 && to == 3) {
			
			// Color wizard
			if ( $('.epkb-wizard-name input').length ) {
				
				// change only if the user changed something on this page 
				if ( need_to_apply_theme ) {
					
					// change only once
					need_to_apply_theme = false;
					
					// move template to the next step when we press 'next'
					$('#eckb-wizard-main-page-preview').html( '<div class="eckb-wizard-help__image"></div>' + $('body').find('.epkb-wt-panel--active').html());
					
					let data = JSON.parse($('#eckb-wizard-main-page-preview').find('.theme-values').val());
					
					// set colors on the right panel to theme's colors 
					epkb_try_set_colors_on_panel( 
						data,
						$('.eckb-wizard-colors-content')
					);
				
					// add first preset as current
					$('#epkb-wc-preset-0').data('colors', JSON.parse($('#eckb-wizard-main-page-preview').find('.theme-values').val()));
					let currentThemeName = $('.epkb-wt-tab.epkb-wt--active .epkb-wt-tab__name').text();
					currentThemeName = $('.epkb-wt-tab.epkb-wt--active').data().template_id == 0 ? 'Saved KB' : currentThemeName;
					$('#epkb-wc-preset-0').text(currentThemeName);
					
					// show/hide options groups 
					epkb_toggle_options_groups( $('#eckb-wizard-main-page-preview').find('.theme-values').val() );
					
					// update article page view
					epkb_wizard_update_color_article_view();
				}
			}
		}
		
		// update preview from Main Page colors to Article Page colors 
		if ( from == 3 && to == 4) {

		}
	}

	/**
	 * Quickly scroll the user back to the top.
	 */
	function wizard_scroll_to_top(){
		$("html, body").animate({ scrollTop: 0 }, 0);
	}

	/**
	 * Toggle the Step information
	 *
	 */
	wizard.find( '.epkb-wizard-header__info__desc-toggle' ).on( 'click', function(){
		wizard.find( '.epkb-wizard-header__desc-container' ).slideToggle();
	});


	/**
	 * Button JS for next Step.
	 *
	 */
	wizard.find( '#epkb-wizard-button-next' ).on( 'click' , function(e){
		e.preventDefault();

		// Get the Step values
		let nextStep = Number( wizard.find( '#epkb-wizard-button-next' ).val() );
		let prevStep = Number( wizard.find( '#epkb-wizard-button-prev' ).val() );

		// Remove all Active Step classes in Step Status Bar.
		$( '.epkb-wsb-step' ).removeClass( 'epkb-wsb-step--active' );

		// Add Active class to next Step in Status Bar.
		$( '#epkb-wsb-step-'+nextStep ).addClass( 'epkb-wsb-step--active' );

		// Remove all active class from panels.
		$( '.epkb-wc-step-panel' ).removeClass( 'epkb-wc-step-panel--active' );

		// Add Active class to next panel in the steps.
		$( '#epkb-wsb-step-'+nextStep+'-panel' ).addClass( 'epkb-wc-step-panel--active' );

		// Update the Previous and Next Data values.
		$( '#epkb-wizard-button-prev' ).val( prevStep+1 );
		$( '#epkb-wizard-button-next' ).val( nextStep+1 );

		wizard_status_bar_highlight_completed_steps( nextStep );
		wizard_change_buttons();
		wizard_show_step_description();
		wizard_changed_step(nextStep-1, nextStep);
		wizard_scroll_to_top();
	});

	/**
	 * Button JS for prev Step.
	 *
	 */
	wizard.find( '#epkb-wizard-button-prev' ).on( 'click' , function(e){
		e.preventDefault();

		// Get the Step values
		let nextStep = Number( wizard.find( '#epkb-wizard-button-next' ).val() );
		let prevStep = Number( wizard.find( '#epkb-wizard-button-prev' ).val() );

		// Remove all Active Step classes in Step Status Bar.
		$( '.epkb-wsb-step' ).removeClass( 'epkb-wsb-step--active' );

		// Add Active class to next Step in Status Bar.
		$( '#epkb-wsb-step-'+prevStep ).addClass( 'epkb-wsb-step--active' );

		// Remove all active class from panels.
		$( '.epkb-wc-step-panel' ).removeClass( 'epkb-wc-step-panel--active' );

		// Add Active class to next panel in the steps.
		$( '#epkb-wsb-step-'+prevStep+'-panel' ).addClass( 'epkb-wc-step-panel--active' );

		// Update the Previous and Next Data values.
		$( '#epkb-wizard-button-prev' ).val( prevStep-1 );
		$( '#epkb-wizard-button-next' ).val( nextStep-1 );

		wizard_status_bar_highlight_completed_steps( prevStep );
		wizard_change_buttons();
		wizard_show_step_description();
		wizard_changed_step(prevStep+1,prevStep);
		wizard_scroll_to_top();
	});

	/**
	 * Theme Toggle JS
	 *
	 */
	wizard.find( '.epkb-wt-tab' ).on( 'click' , function(e){

		// Get Tab ID Value and Template ID
		let tab = $( this );
		let id = tab.attr( 'id' );
		let panel = $( '#'+id+'-panel' );

		// Remove all Active Tab classes
		$( '.epkb-wt-tab' ).removeClass( 'epkb-wt--active' );

		// Add Active class to click on theme.
		tab.addClass( 'epkb-wt--active' );

		// Remove all active class from panels.
		$( '.epkb-wt-panel' ).removeClass( ' epkb-wt-panel--active' );

		// Add Active class to panel with the same id
		panel.addClass( 'epkb-wt-panel--active' );
		
		// change styles for the tabs 
		let styles = JSON.parse(panel.find('.theme-values').val());
		
		if (styles) {
		
			$('#epkb-advanced-style').html(`
				#epkb-content-container .epkb-nav-tabs .active:after {
					border-top-color: ${styles.tab_nav_active_background_color}!important
				}
				#epkb-content-container .epkb-nav-tabs .active {
					background-color: ${styles.tab_nav_active_background_color}!important
				}
				#epkb-content-container .epkb-nav-tabs .active .epkb-category-level-1,
				#epkb-content-container .epkb-nav-tabs .active p {
					color: ${styles.tab_nav_active_font_color}!important
				}
				#epkb-content-container .epkb-nav-tabs .active:before {
					border-top-color: ${styles.tab_nav_border_color}!important
				}		
			`);
			original_styles = $('#epkb-advanced-style').html();
		}
		
		// set value true to change color pickers on "next" button click
		need_to_apply_theme = true;
	});

	/** Change colors on the Main and Article page settings */
	
	let original_styles = $('#epkb-advanced-style').html();
	
	$('body').on('color_changed', 'input', function(){
		let that = $(this);
		
		setTimeout(function(){
		if ( that.data('target_selector') ) {
			let $target = $( that.data('target_selector') );
			
			if ($target.length) {
				let new_styles = {};
				new_styles[that.data('style_name')] = that.val();
				$target.css(new_styles);
			}
			
			if ( that.data('target_selector') == 'tab_nav_active_font_color' 
				|| that.data('target_selector') == 'tab_nav_active_background_color' 
				|| that.data('target_selector') == 'tab_nav_border_color' 
				|| that.data('target_selector') == 'article_toc_cursor_hover_bg_color'
				|| that.data('target_selector') == 'article_toc_active_bg_color'
				|| that.data('target_selector') == 'article_toc_active_text_color'
				|| that.data('target_selector') == 'article_toc_cursor_hover_text_color' ) { 
					let tab_nav_active_font_color = $('.eckb-wizard-step-3 input[name=tab_nav_active_font_color]').val();
					let tab_nav_active_background_color = $('.eckb-wizard-step-3 input[name=tab_nav_active_background_color]').val();
					let tab_nav_border_color = $('.eckb-wizard-step-3 input[name=tab_nav_border_color]').val();
					let article_toc_cursor_hover_bg_color = $('.eckb-wizard-step-4 input[name=article_toc_cursor_hover_bg_color]').val();
					let article_toc_cursor_hover_text_color = $('.eckb-wizard-step-4 input[name=article_toc_cursor_hover_text_color]').val();
					let article_toc_active_text_color = $('.eckb-wizard-step-4 input[name=article_toc_active_text_color]').val();
					let article_toc_active_bg_color = $('.eckb-wizard-step-4 input[name=article_toc_active_bg_color]').val();
					// special trigger for active tabs 
					$('#epkb-advanced-style').html( original_styles + `
						#epkb-wsb-step-3-panel #epkb-content-container .epkb-nav-tabs .active:after {
							border-top-color: ${tab_nav_active_background_color} !important;
						}
						
						#epkb-wsb-step-3-panel #epkb-content-container .epkb-nav-tabs .active {
							background-color: ${tab_nav_active_background_color} !important;
						}
						#epkb-wsb-step-3-panel #epkb-content-container .epkb-nav-tabs .active .epkb-category-level-1,
						#epkb-wsb-step-3-panel #epkb-content-container .epkb-nav-tabs .active p {
							color: ${tab_nav_active_font_color} !important;
						}
						#epkb-wsb-step-3-panel #epkb-content-container .epkb-nav-tabs .active:before {
							border-top-color: ${tab_nav_border_color} !important;
						}
						
						#epkb-wsb-step-3-panel #epkb-content-container .epkb-nav-tabs {
							border-bottom-color: ${tab_nav_border_color} !important;
						}
						.eckb-wizard-step-4 .eckb-article-toc ul a.active {
							background: ${article_toc_active_bg_color} !important;
							color: ${article_toc_active_text_color} !important;
						}
						.eckb-wizard-step-4 .eckb-article-toc ul a:hover {
							background: ${article_toc_cursor_hover_bg_color} !important;
							color: ${article_toc_cursor_hover_text_color} !important;
						} 	`);
				}
		} }, 50);
	});

	/**
	 * Handle Apply Button
	 *
	 */
	wizard.find( '.epkb-wizard-button-apply' ).on( 'click' , function(e){
		
		let wizard_type = $(this).data('wizard-type');
		let kb_config = {};
		let menu_ids = [];

		let postData = {
			wizard_type: wizard_type,
			action: 'epkb_apply_wizard_changes',
			_wpnonce_apply_wizard_changes: $('#_wpnonce_apply_wizard_changes').val(),
			epkb_wizard_kb_id: $('#epkb_wizard_kb_id').val(),
		};

		if ( wizard_type == 'theme' ) {
			// Get Tab ID Value and Template ID
			kb_config = JSON.parse( $('#epkb-wsb-step-3-panel .theme-values').val() );
			
			// change template values to the values from inputs 
			$('#epkb-wsb-step-3-panel .eckb-wizard-colors-content input, #epkb-wsb-step-4-panel .eckb-wizard-colors-content input').each(function(){
				if (kb_config[$(this).attr('name')] !== 'undefined') {
					kb_config[$(this).attr('name')] = $(this).val();
				}
			});

			if ( $('.epkb-menu-checkbox input[type=checkbox]:checked').length ) {
				$('.epkb-menu-checkbox input[type=checkbox]:checked').each(function(){
					menu_ids.push($(this).prop('name').split('epkb_menu_')[1]);
				});
			}

			postData.kb_name = $('.epkb-wizard-name input').val();
			postData.kb_slug = $('.epkb-wizard-slug input').val();
			postData.menu_ids = menu_ids;

		} else if ( wizard_type == 'text' ) {
			// Get Tab ID Value and Template ID
			kb_config = JSON.parse( $('#eckb_current_theme_values').val() );
			
			$('.eckb-wizard-single-text input').each(function(){
				if (kb_config[$(this).attr('name')] !== 'undefined') {
					kb_config[$(this).attr('name')] = $(this).val();
				}
			});
		}

		postData.kb_config = kb_config;

		epkb_send_ajax ( postData, function( response ) {
			// after ajax function 
			
			if ( wizard_type == 'theme' ) {
				if ( ! response.error && typeof response.message !== 'undefined' ) {
					$('#epkb-wsb-step-5-panel').removeClass('epkb-wc-step-panel--active');
					$('#epkb-kb-main-page-link').attr('href', response.kb_main_page_link);
					$('#epkb-wsb-step-6-panel').addClass('epkb-wc-step-panel--active').show();
				}

			} else if ( wizard_type == 'text' ) {
				if ( ! response.error && typeof response.message !== 'undefined' ) {
					$('#epkb-wsb-step-3-panel').removeClass('epkb-wc-step-panel--active');
					$('#epkb-wsb-step-4-panel').addClass('epkb-wc-step-panel--active').show();
				}
			}

			$('.epkb-wizard-button-container').hide();

		}, false, epkb_vars.save_config);

	});

	/**
	 * SHOW INFO MESSAGES
	 */
	function epkb_admin_notification( $title, $message , $type ) {
		
		return '<div class="eckb-bottom-notice-message">' +
			'<div class="contents">' +
			'<span class="' + $type + '">' +
			($title ? '<h4>' + $title + '</h4>' : '' ) +
			($message ? $message : '') +
			'</span>' +
			'</div>' +
			'</div>';
	}
	
	/** 
	 * Set colors on the panel from JSON or object
	 * $data - json or object where { input_name : value }
	 * $panel_parent jQuery object with parent div of the color panel 
	*/
	function epkb_try_set_colors_on_panel( data, $panel_parent ) {
		
		if ( typeof $data == 'string') {
			data = JSON.parse( $data );
		}
		
		if (data.length == 0) {
			return;
		}
		
		// check colors 
		$panel_parent.find('input.wp-color-picker').each(function(){
			if ( typeof data[$(this).attr('name')] !== 'undefined' ) {
				$(this).val(data[$(this).attr('name')]).iris('color', data[$(this).attr('name')]);//trigger('color_changed')
			}
		});
		
	}
	
	/**
	 * Preset functions 
	 */
	$('body').on('click', '.epkb-preset-button', function(){
		let data = $(this).data('colors');
		
		if ($(this).closest('#epkb-wsb-step-3-panel').length) {
			// Main page presets 
			
			epkb_try_set_colors_on_panel( 
				data,
				$('.eckb-wizard-colors-content')
			);
		}
	});
	
	/**
	 * Check and toggle option groups depends on the options of the current template 
	 */
	function epkb_toggle_options_groups( $options_input ) {
		
		if ( ! $options_input.length ) {
			return;
		}
		
		let config = JSON.parse( $options_input );
		$('.eckb-wizard-colors-content, .eckb-wizard-texts-content').each(function(){
			let depends = $(this).data('depends');
				
			if ( depends === undefined ) {
				return;
			}


			// check show off options - they are primary
			let show = true;
			let values = '';

			if ( depends.show_when !== undefined && Object.keys(depends.show_when) ) {

				show = false;
				for ( let name in depends.show_when ) {

					if ( config[name] !== undefined ) {
						values = depends.show_when[name];
						values = values.split('|');

						for ( let val of values ) {

							if ( config[name] == val ) {
								show = true;
								break;
							}
						}
					}
				}
			}

			if ( depends.hide_when !== undefined && Object.keys(depends.hide_when) ) {

				for ( let name in depends.hide_when ) {

					if ( config[name] !== undefined ) {
						values = depends.hide_when[name];
						values = values.split('|');

						for ( let val of values ) {

							if ( config[name] == val ) {
								show = false;
								break;
							}
						}
					}
				}
			}

			if ( show ) {
				$(this).show();
			} else {
				$(this).hide();
			}
		});
	}
	
	/**
	 * Accordion for the options 
	 */
	$('body').on('click', '.eckb-wizard-accordion .eckb-wizard-option-heading', function(){
		let wrap = $(this).closest('.eckb-wizard-accordion');
		let currentItem = $(this).closest('.eckb-wizard-accordion__body-content');
		let isCurrentActive = currentItem.hasClass('eckb-wizard-accordion__body-content--active');

		wrap.find('.eckb-wizard-accordion__body-content').removeClass('eckb-wizard-accordion__body-content--active');
		
		if (!isCurrentActive) {
			currentItem.addClass('eckb-wizard-accordion__body-content--active');
		}
		
	});

	$('body').on('click', '#eckb-wizard-main-page-preview a, .epkb-wizard-theme-panel-container a, #eckb-wizard-article-page-preview a', false);


	/********************************************************************
	 *                      Article TOC
	 ********************************************************************/
	function activate_TOC() {
		
		var articleContent = $('#eckb-article-content-body');
		var articleToc     = $('.eckb-article-toc');
		if (articleToc.length) {

			if ( !articleToc.data('min') ) {
				articleToc.data('min', 1);
			}

			if ( !articleToc.data('offset') ) {
				articleToc.data('offset', 50);
			}

			let firstLevel = articleToc.data('min');
			let searchStr = 'h' + firstLevel;
			let params = {'scrollOffset' : articleToc.data('offset')};
			let exclude_class = false;
			
			if ( typeof articleToc.data('exclude_class') !== 'undefined' ) {
				exclude_class = articleToc.data('exclude_class');
			}
			
			while ( firstLevel < 6 ) {
				firstLevel++;
				searchStr += ', h' + firstLevel;
			}

			// return object with headers and their ids
			function getArticleHeaders() {
				let headers = [];

				articleContent.find(searchStr).each(function(){
					
					if ( $(this).text().length == 0 ) {
						return;
					}
					
					if ( exclude_class && $(this).hasClass( articleToc.data('exclude_class') ) ) {
						return;
					}
						
					let tid;
					let header = {};

					if ($(this).prop('id')) {
						tid = $(this).prop('id');
					} else {
						tid = 'articleTOC_' + headers.length;
						$(this).prop('id', tid);
					}

					header.id = tid;
					header.title = $(this).text();

					if ('H1' == $(this).prop("tagName")) {
						header.level = 1;
					} else if ('H2' == $(this).prop("tagName")) {
						header.level = 2;
					} else if ('H3' == $(this).prop("tagName")) {
						header.level = 3;
					} else if ('H4' == $(this).prop("tagName")) {
						header.level = 4;
					} else if ('H5' == $(this).prop("tagName")) {
						header.level = 5;
					} else if ('H6' == $(this).prop("tagName")) {
						header.level = 6;
					}

					headers.push(header);
				});

				if ( headers.length == 0 ) {
					return headers;
				}

				// find max and min header level
				let maxH = 1;
				let minH = 6;

				headers.forEach(function(header){
					if (header.level > maxH) {
						maxH = header.level
					}

					if (header.level < minH) {
						minH = header.level
					}
				});

				// move down all levels to have 1 lowest
				if ( minH > 1 ) {
					headers.forEach(function(header, i){
						headers[i].level = header.level - minH + 1;
					});
				}

				// now we have levels started from 1 but maybe some levels do not exist

				// check level exist and decrease if not exist
				let i = 1;

				while (i < maxH) {
					let levelExist = false;
					headers.forEach(function(header){
						if (header.level == i) {
							levelExist = true;
						}
					});

					if (levelExist) {
						// all right, level exist, go to the next
						i++;
					} else {
						// no such levelm move all levels that more than current down and check once more
						headers.forEach(function(header, j){
							if (header.level > i) {
								headers[j].level = header.level - 1;
							}
						});
					}
					i++;
				}

				return headers;
			}

			// return html from headers object
			function getToCHTML(headers) {
				let html;

				if ( articleToc.find('.eckb-article-toc__title').length ) {
					let title = articleToc.find('.eckb-article-toc__title').html();
					html = `
						<div class="eckb-article-toc__inner">
							<div class="eckb-article-toc__title">${title}</div>
							<ul>
						`;
				} else {
					html = `
						<div class="eckb-article-toc__inner">
							<ul>
						`;
				}


				headers.forEach(function(header){
					html += `<li class="eckb-article-toc__level eckb-article-toc__level-${header.level}"><a href="#${header.id}">${header.title}</a></li>`;
				});

				html += `
							</ul>
						</div>
					`;

				return html;
			}

			let articleHeaders = getArticleHeaders();

			// show TOC only if headers preset
			if ( articleHeaders.length > 0 ) {
				articleToc.html(getToCHTML(articleHeaders));
				articleContent.find(searchStr).scrollSpy(params);
				articleToc.fadeIn();
			}
		}
	}
	activate_TOC();
	
	/** 
	 * Update article view on the colors wizard depends of the selected theme 
	 */
	 
	function epkb_wizard_update_color_article_view() {
		// get current config 
		let kb_config = {};
		
		kb_config = JSON.parse( $('#epkb-wsb-step-3-panel .theme-values').val() );	
		// change template values to the values from inputs 
		$('#epkb-wsb-step-3-panel .eckb-wizard-colors-content input, #epkb-wsb-step-4-panel .eckb-wizard-colors-content input').each(function(){
			if (kb_config[$(this).attr('name')] !== 'undefined') {
				kb_config[$(this).attr('name')] = $(this).val();
			}
		});
		
		let postData = {
			action: 'epkb_wizard_update_color_article_view',
			_wpnonce_apply_wizard_changes: $('#_wpnonce_apply_wizard_changes').val(),
			kb_config: kb_config,
		};
		
		epkb_send_ajax( postData, function( response ){
			if ( typeof response.html !== 'undefined' ) {
				$('#eckb-wizard-article-page-preview').html( '<div class="eckb-wizard-help__image"></div>' + response.html);
				activate_TOC();
			}
		}, false, '', true );
	}
	
	/**
	 * Check KB Url and show notice if bad 
	 */
	
	function eckb_wizard_check_slug() {
		let input = $('.epkb-wizard-slug input');
		if ( input.length == 0 ) {
			return true;
		}
		
		let val = input.val();
		let isValid = true;

		if ( val.startsWith("http") ) {
			isValid = false;
		}

		if ( val.startsWith("www") ) {
			isValid = false;
		}

		if ( val.endsWith(".") ) {
			isValid = false;
		}

		if ( val.endsWith(".com") ) {
			isValid = false;
		}

		if ( val.endsWith(".org") ) {
			isValid = false;
		}

		if ( isValid ) {
			$('#epkb-wizard-slug-error').hide();
			$('#epkb-wizard-button-next').prop('disabled', false);
			input.removeClass('epkb-wizard-input-error');
		} else {
			$('#epkb-wizard-slug-error').show();
			$('#epkb-wizard-button-next').prop('disabled', 'disabled');
			input.addClass('epkb-wizard-input-error');
		}
	}
	
	$('.epkb-wizard-slug input').on('change keyup paste', eckb_wizard_check_slug);
	eckb_wizard_check_slug();
	
	/********************************************************************
	 *
	 *                      TEXT WIZARD
	 *
	 ********************************************************************/
	
	/**
	 * Initial Settings
	 */
	
	if ( $('#eckb_current_theme_values').length ) {
		// hide/show texts depends on the config 
		epkb_toggle_options_groups( $('#eckb_current_theme_values').val() );
	}
	
	/** 
	 * Check and change texts when the user change input 
	 */
	$('body').on('change paste keyup', '.eckb-wizard-single-text input', function() {
		let input = $(this);
		
		if ( typeof input.data('target_selector') == 'undefined' ) {
			return;
		}
		
		target = $( input.data('target_selector') );		

		if ( ! target.length ) {
			return;
		}
		
		if ( input.data('text') == '1' ) {
			target.text( input.val() );
		}
		
		epkb_hightlight_changed_element(target);
		
		if ( typeof input.data('target_attr') === 'undefined' ) {
			return;
		}
		
		let attributes = input.data('target_attr').split('|');
		for ( let attribute of attributes ) {
			target.prop( attribute, input.val() );
		}
		
	});

	/** ***********************************************************************************************
	 *
	 *          AJAX calls
	 *
	 * **********************************************************************************************/


	// generic AJAX call handler
	function epkb_send_ajax( postData, refreshCallback, reload, loaderMessage, silent_mode = false ) {

		var errorMsg;
		var theResponse;
		refreshCallback = (typeof refreshCallback === 'undefined') ? 'epkb_callback_noop' : refreshCallback;

		$.ajax({
			type: 'POST',
			dataType: 'json',
			data: postData,
			url: ajaxurl,
			beforeSend: function (xhr)
			{
				if ( ! silent_mode ) {
					$('#epkb-ajax-in-progress').text(loaderMessage).dialog('open');
				}
			}
		}).done(function (response)        {
			theResponse = ( response ? response : '' );
			if ( theResponse.error || typeof theResponse.message === 'undefined' ) {
				//noinspection JSUnresolvedVariable,JSUnusedAssignment
				errorMsg = theResponse.message ? theResponse.message : epkb_admin_notification('', epkb_vars.reload_try_again, 'error');
			}

		}).fail( function ( response, textStatus, error )        {
			//noinspection JSUnresolvedVariable
			errorMsg = ( error ? ' [' + error + ']' : epkb_vars.unknown_error );
			//noinspection JSUnresolvedVariable
			errorMsg = epkb_admin_notification(epkb_vars.error_occurred + '. ' + epkb_vars.msg_try_again, errorMsg, 'error');
		}).always(function ()        {
			if ( ! silent_mode ) {
				$('#epkb-ajax-in-progress').dialog('close');
			}

			if ( errorMsg ) {
				$('.eckb-bottom-notice-message').replaceWith(errorMsg);
				$("html, body").animate({scrollTop: 0}, "slow");
			} else {
				if ( ! silent_mode ) {
					if ( ! theResponse.error && typeof theResponse.message !== 'undefined' ) {
						
						$('.eckb-bottom-notice-message').replaceWith(
							epkb_admin_notification('', theResponse.message, 'success')
						);
					}
				}
				
				if ( typeof refreshCallback === "function" ) {
					theResponse = (typeof theResponse === 'undefined') ? '' : theResponse;
					refreshCallback(theResponse);
				} else {
					if ( reload ) {
						location.reload();
					}
				}
			}
		});
	}
	
	
	/** Help Image */
	function epkb_show_help_image( image_url ) {
		$('.epkb-wc-step-panel--active .eckb-wizard-help__image').css({
			'background-image' : 'url(/wp-content/plugins/echo-knowledge-base/img/wizard/'+image_url+')'
		});
		
		$('.epkb-wc-step-panel--active .eckb-wizard-help').addClass('eckb-wizard-help--active');
	}
	
	function epkb_hide_help_image() {
		setTimeout(function(){
			// check if all color pickers closed 
			if ( $('body').find('.ekb-color-picker .wp-picker-active').length ) {
				return;
			}
			
			$('.eckb-wizard-help__image').css({
				'background-image' : 'none'
			});
			$('.eckb-wizard-help').removeClass('eckb-wizard-help--active');
			
		}, 500); // 500ms we need to wait all scripts like color pickers. Can be less but not recommend for slow computers/mobiles
	}
	
	$('body').on('click', function(){
		epkb_hide_help_image();
	});
	
	$('body').on('focus', '.wp-color-result', function(e){
		let picker = $(this);
		epkb_hide_help_image();
		
		setTimeout(function(){
			if (picker.hasClass('wp-picker-open')) {
				let input = picker.parent().find('.wp-picker-input-wrap input');
				
				if ( input.data('example_image') == undefined ) {
					epkb_hide_help_image();
					return;
				}
				
				epkb_show_help_image(input.data('example_image'));
			}
		}, 500);
		
		e.stopPropagation();
	});
	
	$('body').on('click focus', '.eckb-wizard-single-text input', function(e){

		if ( $(this).data('example_image') == undefined ) {
			epkb_hide_help_image();
			return;
		}
		
		epkb_show_help_image($(this).data('example_image'));
		return false;
	});
	
	/** Text Wizard: Highlight text changed element */
	
	function epkb_hightlight_changed_element( $el ) {
		console.log($el);
		if ( typeof $el.data('old_transition') == 'undefined' ) {
			$el.data('old_transition', $el.css('transition'));
			$el.data('old_shadow', $el.css('transition'));
		}
		
		$el.data('hightlight_coming', 'yes');
		
		$el.css({
			'transition' : '0.2s',
			'box-shadow' : 'inset 0 0 0px 0px #1bff1b'
		});
		
		$el.css({
			'box-shadow' : 'inset 0 0 20px 0px #1bff1b'
		});
		
		setTimeout( function() {
			$el.css({
				'box-shadow' : 'inset 0 0 0px 0px #1bff1b'
			});
			
			$el.data('hightlight_coming', 'no');
		}, 1000);
		
		setTimeout( function() {
			if ($el.data('hightlight_coming') == 'no') {
				$el.css({
					'transition' : $el.data('old_transition'),
					'box-shadow' : $el.data('old_shadow')
				});
			}
		}, 2000);
	}
});