<?php  if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Holds demo data for KB
 *
 * @copyright   Copyright (C) 2018, Echo Plugins
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */
class EPKB_KB_Demo_Data {

	public static function get_category_demo_data( $layout, $kb_config ) {

		$articles_sequence_new_value = isset($kb_config['articles_display_sequence']) ? $kb_config['articles_display_sequence'] : '';
		$categories_sequence_new_value = isset($kb_config['categories_display_sequence']) ? $kb_config['categories_display_sequence'] : '';

		if ( $categories_sequence_new_value == 'alphabetical-title' ) {
			$category_seq = array(
				'11' => array(), //'111' => array('1111' => array())),
				'22' => array( '222' => array( '2222' => array() ) ),
				'33' => array(), //'333' => array('3333' => array())),
				'66' => array(),
				'55' => array(), //'555' => array('5555' => array())),
				'44' => array( '444' => array( '4444' => array() ) )
			);
		} else {
			$category_seq = array(
				'11' => array(), //'111' => array('1111' => array())),
				'22' => array( '222' => array( '2222' => array() ) ),
				'33' => array(), //'333' => array('3333' => array())),
				'44' => array( '444' => array( '4444' => array() ) ),
				'55' => array(), //'555' => array('5555' => array())),
				'66' => array()
			);
		}

		if ( $layout == EPKB_KB_Config_Layout_Tabs::LAYOUT_NAME ) {
			if ( $categories_sequence_new_value == 'alphabetical-title' ) {
				$category_seq['11'] += array( '112' => array() );
				$category_seq['11'] += array( '115' => array() );
				$category_seq['11'] += array( '113' => array() );
				$category_seq['11'] += array( '116' => array() );
				$category_seq['11'] += array( '114' => array() );
				$category_seq['11'] += array( '111' => array() );
			} else {
				$category_seq['11'] += array( '111' => array() );
				$category_seq['11'] += array( '112' => array() );
				$category_seq['11'] += array( '113' => array() );
				$category_seq['11'] += array( '114' => array() );
				$category_seq['11'] += array( '115' => array() );
				$category_seq['11'] += array( '116' => array() );
			}
		}
		
		$cat_11_descr = 'Your Account Settings ';
		$cat_22_descr = 'Search & Browse for Items';
		$cat_33_descr = 'Payment methods, gift cards and fees';
		$cat_44_descr = 'Rates, Rules , Tracking';
		$cat_55_descr = 'Refund conditions and rules';
		$cat_66_descr = 'Promotions and special pricing';

		if ( $articles_sequence_new_value == 'alphabetical-title' ) {
			$article_seq = array(
				'11' => array(0 => 'Account', 1 => $cat_11_descr, 2 => 'Create Account', 3 => 'Order History', 4 => 'Login Issues'),
				'22' => array(0 => 'Ordering', 1 => $cat_22_descr, 2 => 'Editing an Order', 3 => 'Placing an Order', 4 => 'Pre/back-orders'),
				'222' => array(0 => 'Order Processing', 1 => '', 2 => 'Canceling an Order', 3 => 'Order verification', 4 => 'Un-canceling an Order'),
				'2222' => array(0 => 'Order Processing Time', 1 => '', 2 => 'How Will I Know If You Have Received My Order?', 3 => 'When is My Order Processed?', 4 => 'When Will I Receive My Order?'),
				'33' => array(0 => 'Payment', 1 => $cat_33_descr, 2 => 'Gift Cards', 3 => 'Payment methods', 4 => 'Taxes and Fees'),
				'44' => array(0 => 'Shipping', 1 => $cat_44_descr, 2 => 'Shipping Issues', 3 => 'Shipping options', 4 => 'Tracking an Order'),
				'444' => array(0 => 'Shipping Options', 1 => '', 2 => 'Calculating the Shipping Cost', 3 => 'Free shipping', 4 => 'PO Boxes'),
				'4444' => array(0 => 'Shipping Rates', 1 => '', 2 => 'Australia', 3 => 'Canada', 4 => 'France', 5 => 'Germany', 6 => 'Spain', 7 => 'Russia', 8 => 'China', 9 => 'US'),
				'55' => array(0 => 'Returns & Refunds', 1 => $cat_55_descr, 2 => 'Creating a Return', 3 => 'Return Guidelines', 4 => 'Return Shipping'),
				'66' => array(0 => 'Pricing/Promos', 1 => $cat_66_descr, 2 => 'Newsletter', 3 => 'Pricing Guidelines', 4 => 'Promotions'),
			);
		} else {
			$article_seq = array(
				'11' => array(0 => 'Account', 1 => $cat_11_descr, 2 => 'Create Account', 3 => 'Login Issues', 4 => 'Order History'),
				'22' => array(0 => 'Ordering', 1 => $cat_22_descr, 2 => 'Placing an Order', 3 => 'Editing an Order', 4 => 'Pre/back-orders'),
				'222' => array(0 => 'Order Processing', 1 => '', 2 => 'Order verification', 3 => 'Canceling an Order', 4 => 'Un-canceling an Order'),
				'2222' => array(0 => 'Order Processing Time', 1 => '', 2 => 'When is My Order Processed?', 3 => 'How Will I Know If You Have Received My Rrder?', 4 => 'When Will I Receive My Order?'),
				'33' => array(0 => 'Payment', 1 => $cat_33_descr, 2 => 'Payment methods', 3 => 'Taxes and Fees', 4 => 'Gift Cards'),
				'44' => array(0 => 'Shipping', 1 => $cat_44_descr, 2 => 'Shipping Options', 3 => 'Tracking an Order', 4 => 'Shipping Issues'),
				'444' => array(0 => 'Shipping Options', 1 => '', 2 => 'Calculating the Shipping Cost', 3 => 'Free Shipping', 4 => 'PO Boxes'),
				'4444' => array(0 => 'Shipping Rates', 1 => '', 2 => 'US', 3 => 'Canada', 4 => 'Germany', 5 => 'France', 6 => 'Spain', 7 => 'Russia', 8 => 'Hong Kong', 9 => 'Australia'),
				'55' => array(0 => 'Returns & Refunds', 1 => $cat_55_descr, 2 => 'Creating a Return', 3 => 'Return Guidelines', 4 => 'Return Shipping'),
				'66' => array(0 => 'Pricing/Promos', 1 => $cat_66_descr, 2 => 'Pricing Guidelines', 3 => 'Promotions', 4 => 'Newsletter'),
			);
		}

		if ( $layout == EPKB_KB_Config_Layout_Tabs::LAYOUT_NAME ) {
			$article_seq['111'] = array( 0 => 'Login Issues', 1 => '', 2 => 'Problems Logging in', 3 => 'Too Many Login Attempts' );
			$article_seq['112'] = array( 0 => 'Account Settings', 1 => '', 2 => 'Changing Your Password', 3 => 'Recover Password' );
			$article_seq['113'] = array( 0 => 'History', 1 => '', 2 => 'Download Account History', 3 => 'Your Browsing History' );
			$article_seq['114'] = array( 0 => 'Premium Account', 1 => '', 2 => 'Different Types', 3 => 'How Do I Upgrade to a Premium Account', 4 => 'How do I Manage my Premium Account' );
			$article_seq['115'] = array( 0 => 'Additional Services', 1 => '', 2 => 'What is Open Profile', 3 => 'What Currencies are Supported' );
			$article_seq['116'] = array( 0 => 'Other', 1 => '', 2 => 'Account Overview', 3 => 'Create Account' );
		}

		$category_icons = EPKB_KB_Config_Layout_Tabs::LAYOUT_NAME == $layout ?
							// Tab Layout
							array(
								111 => 'ep_font_icon_person',       // Login Issues
								112 => 'ep_font_icon_gears',        // Account Settings
								113 => 'ep_font_icon_data_report',  // History
								114 => 'epkbfa-cubes',              // Premium Account
								115 => 'epkbfa-bookmark-o',         // Additional Services
								116 => 'ep_font_icon_pencil'        // Other
							) :
							// Basic Layout
							array(
								11 => 'ep_font_icon_person',        // Account
								22 => 'ep_font_icon_shopping_cart', // Ordering
								33 => 'ep_font_icon_credit_card',   // Payment
								44 => 'epkbfa-truck',               // Shipping
								55 => 'epkbfa-bookmark',            // Returns & Refunds
								66 => 'ep_font_icon_money'          // Pricing / Promos
							);

		return array( 'category_seq' => $category_seq, 'article_seq' => $article_seq, 'category_icons' => $category_icons );
	}

	public static function get_demo_article() {
		return "
			<h1>Header Level 1</h1>
			<strong>Pellentesque habitant morbi tristique</strong> senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.
			 Donec eu libero sit amet quam egestas semper. <em>Aenean ultricies mi vitae est.</em>
			<h2>Header Level 2</h2>
			<ol>
	            <li>Lorem ipsum dolor sit amet, consectetuer adipiscing elit.</li>
	            <li>Aliquam tincidunt mauris eu risus.</li>
			</ol>
			<h3>Header Level 3</h3>
			<ul>
	            <li>Lorem ipsum dolor sit amet, consectetuer adipiscing elit.</li>
	            <li>Aliquam tincidunt mauris eu risus.</li>
			</ul>	
			";
	}
	
	// Demo categories for sidebar 
	public static function get_demo_categories_list() {
		return array(
		/*	array(
				'name' => 'FAQs',
				'active' => true,
				'count' => 1
			),
			array(
				'name' => 'Introduction',
				'active' => false,
				'count' => 5
			),
			array(
				'name' => 'Other',
				'active' => false,
				'count' => 0
			), */

			array(
				'name' => 'Account',
				'category_id' => 11,
				'active' => true,
				'count' => 3
			),
			array(
				'name' => 'Order Processing',
				'category_id' => 222,
				'active' => false,
				'count' => 1
			),
			array(
				'name' => 'Ordering',
				'category_id' => 22,
				'active' => false,
				'count' => 4
			),

			array(
				'name' => 'Payment',
				'category_id' => 33,
				'active' => false,
				'count' => 3
			),
			array(
				'name' => 'Shipping Options',
				'category_id' => 444,
				'active' => false,
				'count' => 2
			),
			array(
				'name' => 'Shipping',
				'category_id' => 44,
				'active' => false,
				'count' => 5
			),
			array(
				'name' => 'Returns & Refunds',
				'category_id' => 55,
				'active' => false,
				'count' => 3
			),
			array(
				'name' => 'Pricing/Promos',
				'category_id' => 66,
				'active' => false,
				'count' => 3
			),
		);
	}
}
