<?php  if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Display wizard information that is displayed with KB Configuration page
 *
 * @copyright   Copyright (C) 2018, Echo Plugins
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */
class EPKB_KB_Config_Wizards {

	/**
	 * Display wizard Page
	 * @param $kb_id
	 */
	public static function display_page( $kb_id ) { ?>
		<div class="epkb-wizards" id="epkb-config-wizards-content" >

			<section class="epkb-wizards__section-intro">
				<h1>Easy Configuration with Wizard</h1>
				<p>Each Wizard will help you setup a different aspect of the Knowledge Base.</p>
			</section>  <?php

			// ensure users have latest add-on
			if ( EPKB_KB_Wizard::is_wizard_disabled() ) {
				echo '<div class="epkb-wizard-error-note">' . __('Elegant Layouts, Advanced Search and Article Rating plugins need to be up to date. ', 'echo-knowledge-base') . EPKB_Utilities::contact_us_for_support() . '</div>';
				return;
			}

			$page_url = 'edit.php?post_type=' . EPKB_KB_Handler::get_post_type( $kb_id );
			$plugin_version_first = get_option( 'epkb_version_first' );
			$is_blank_kb = EPKB_Utilities::is_blank_KB( $kb_id );
			if ( empty($plugin_version_first) || $is_blank_kb ) {
				self::display_initial_wizard( $page_url );
			} else {
				self::display_full_wizard( $page_url );
			}	?>

		</div>	<?php
	}

	private static function display_initial_wizard( $page_url ) {         ?>
		<section class="epkb-wizards__row-3-col">				<?php
			self::display_wizard_box_1( array(
					'icon_class'    => 'epkbfa-paint-brush',
					'title'         => 'Theme Wizard',
					'content'       => 'Configure KB look, style and colors.',
					'btn_text'      => 'Run Wizard',
					'btn_url'       =>  admin_url( $page_url ) . '&page=epkb-kb-configuration&wizard-on',
			));     ?>
		</section>      <?php
	}

	private static function display_full_wizard( $page_url ) {         ?>

		<section class="epkb-wizards__row-3-col">				<?php
				self::display_wizard_box_1( array(
					'icon_class'    => 'epkbfa-paint-brush',
					'title'         => 'Theme Wizard',
					'content'       => 'Configure the KB look, style, and colors.',
					'btn_text'      => 'Run Wizard',
					'btn_url'       =>  admin_url( $page_url ) . '&page=epkb-kb-configuration&wizard-on',
				));

				self::display_wizard_box_1( array(
						'icon_class'    => 'epkbfa-font',
						'title'         => 'Text Wizard',
						'content'       => 'Change predefined text strings or set them to your native language.',
						'btn_text'      => 'Run Wizard',
						'btn_url'       => admin_url( $page_url ) . '&page=epkb-kb-configuration&wizard-text-on',
				));

				/* self::display_wizard_box_1( array(
					'icon_class'    => 'epkbfa-globe',
					'title'         => 'Global Wizard',
					'content'       => 'Change settings that effect the whole knowledge base.',
					'btn_text'      => 'Run Wizard',
					'btn_url'       => '#',
				)); */				?>
			</section>
		<section class="epkb-wizards__row-3-col">				<?php
				/* $kb_config = empty($kb_config) ? epkb_get_instance()->kb_config_obj->get_current_kb_configuration() : $kb_config;
				self::display_wizard_box_1( array(
					'icon_class'    => 'epkbfa-cube',
					'title'         => 'Main Page Wizard',
					'content'       => 'Configure your main page settings.',
					'btn_text'      => 'Run Wizard',
					'btn_url'       =>  '#'
				));

				self::display_wizard_box_1( array(
					'icon_class'    => 'epkbfa-file-text',
					'title'         => 'Article Wizard',
					'content'       => 'Configure your Article page settings.',
					'btn_text'      => 'Run Wizard',
					'btn_url'       => '#'
				));
				self::display_wizard_box_1( array(
					'icon_class'    => 'epkbfa-arrows',
					'title'         => 'Organize Wizard',
					'content'       => 'Change the sort order of your Categories and articles',
					'btn_text'      => 'Run Wizard',
					'btn_url'       => '#'
				));  */				?>
			</section>      <?php
	}


	/**
	 * Show a box with Icon, Title, Description and Link
	 *
	 * @param $args array

	 * - ['icon_class']     Top Icon to display ( Choose between these available ones: https://fontawesome.com/v4.7.0/icons/ )
	 * - ['title']          H3 title of the box.
	 * - ['content']        Body content of the box.
	 * - ['btn_text']       Show button and the text of the button at the bottom of the box, if no text is defined no button will show up.
	 * - ['btn_url']        Button URL.
	 */
	public static function display_wizard_box_1( $args ) { ?>

		<div class="epkb-wizard-box-container_1">

			<!-- Header -------------------->
			<div class="epkb-wizard-box__header">
				<i class="epkb-wizard-box__header__icon epkbfa <?php echo $args['icon_class']; ?>"></i>
				<h3 class="epkb-wizard-box__header__title"><?php echo $args['title']; ?></h3>
			</div>

			<!-- Body ---------------------->
			<div class="epkb-wizard-box__body">
				<?php echo $args['content']; ?>
			</div>

			<!-- Footer ---------------------->
			<div class="epkb-wizard-box__footer">
					<a class="epkb-wizard-box__footer__button" href="<?php echo esc_url( $args['btn_url'] ); ?>"><?php echo $args['btn_text']; ?></a>
			</div>

		</div>	<?php
	}
}
