<?php
/**
 * Copyright 2013 Asim Liaquat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace Google\Spreadsheet\Batch;

use SimpleXMLElement;

/**
 * BatchResponse
 *
 * @package    Google
 * @subpackage Spreadsheet
 */
class BatchResponse
{
    /**
     *
     * @var SimpleXMLElement
     */
    protected $xml;
    
    /**
     * 
     * @param SimpleXMLElement $xml
     */
    public function __construct(SimpleXMLElement $xml)
    {
        $this->xml = $xml;
    }
    
    /**
     * 
     * @return SimpleXMLElement
     */
    public function getXml()
    {
        return $this->xml;
    }
    
    /**
     * 
     * @return boolean
     */
    public function hasErrors()
    {
        foreach ($this->xml->xpath("//batch:status/@code") as $el) {
            if($el->__toString() !== "200") {
                return true;
            }
        }
        
        return false;
    }
    
}
